#!/usr/bin/perl

#     
#    
#    26  2002 --    
#       2003-03-27 --     (  )
#       2003-12-06 --    -2003
#                     (       )
#       2004-03-22 --     
#                     (  ,   )

#  :
#
#     
#
#   nnnnn-I.TXT  nnnnn-R.TXT
#    nnnnn -  
#
#  :
# ...
#
#  :
# nnnn ,  
#    nnnn -    
#     -    
#     -  
#
#  -  
#      (  %)
#
#  INF -   
#  |  |  |   | 
#    ( |  :)
# 0    
# 1    
# ...
#
#  RES -         
#   +- ... +- 
#

#---------------------------------------------------------------------
#    
require 'param.txt';
$region = uc ($ARGV[0] || $region);

#    
require 'myparam.pl';

#  
require 'charset.pl';

#   
require 'messages.pl';

#   
require 'proc.pl';

#---------------------------------------------------------------------
#    
#---------------------------------------------------------------------

die $msg_nout if $screen_code eq ''  &&  $file_code eq '';

%charset = ('dos' => 'dos',  'win' => 'win',  'koi' => 'koi',  '' => 'empty');

die $msg_badscreencode unless $charset{$screen_code};
$screen_charset = "${$screen_code}";

die russian ($msg_badfilecode, $innercode, $screen_charset)
    unless $charset{$file_code};
$file_charset = "${$file_code}";

$file_code && ((open OUT, ">$file_name") || 
   die russian ("$msg_cannotcreatefile: $!\n", $innercode, $screen_charset));

#---------------------------------------------------------------------
for $type ('I', 'R') {
   $f = "G$type-$region.TXT";
   unless (open IN, $f) {
      error ("$msg_nofile", $f);
      next;
   }
   testhead();
   eval "test$type()";
   close IN;
}
error ($msg_OK) unless $errors;

#---------------------------------------------------------------------
#   
#---------------------------------------------------------------------
sub testhead 
{
   $in_charset = setcode ($_ = <IN>);
   unless ($in_charset)
   {
      error ($msg_nocharsetinfile, $f);
      $in_charset = $innercode;
   }
   $_ = russian ($_, $in_charset, $innercode);
   error ($msg_badfirstline, $f) unless eval ("/^\\s*$head_line1\\s*\$/");
   $_=<IN>; #  
   $_ = russian ($_, $in_charset, $innercode);
   if (/^\s*(\w+)\s+(.+?)\s*,\s*(.+?)\s*$/) {
      error ($msg_badcitycode, $f, $1) unless $1 eq $region;
      error ($msg_badcityname, $f, $3) unless $3 eq getcityname($region);
   } else {
      error ($msg_badsecondline, $f);
   }
}

sub testI
{
   %team=();
   my %teamnum=();
   while (<IN>)
   {
      chomp;  s/\s*$//; s/^\s*//;
      next if /^$/ || /^%/; # skip empty lines and comments
      $_ = russian($_, $in_charset, $innercode);
      if (/^\d/) { #  
         /^(\d)\s+(.+)$/ || error ($msg_badmember, $f, $_);
         error ($msg_memberbeforeteam, $f, $_) unless $teamcode;
         error ($msg_doublemember, $f, $1, $teamcode) if $member[$1];
         $member[$1] = $2;
         error ($msg_badcap, $f, $teamcode) if ($1==0 and $2 ne $captain);
      }
      else { #  
         #  -     
         error ($msg_nocap, $f, $teamcode) if ($teamcode && $captain && !$member[0]);
         error ($msg_nomembers, $f, $teamcode) if ($teamcode and scalar @member == 0);
         @member = ();
         ($teamcode, $teamname, $captain, $city) = split /\s*[|:]\s*/;
         if ($teamcode !~ /^(\w{5})\d{3}$/)
            {error ($msg_badteamcode,$f,$teamcode);}
         else
         {
            error ($msg_badcitycodeinteam,$f,$teamcode) if $1 ne $region;
         }
         if (exists $team{$teamcode})
            {error ($msg_doublecode,$f,$teamcode)}
         else
            { @{$team{$teamcode}}=() }
         error ($msg_noteamdata,$f,$teamcode) if (!$captain && !$teamname);
      }
   }
   error ($msg_nocap, $f, $teamcode) if ($teamcode && $captain && !$member[0]);
   error ($msg_nomembers, $f, $teamcode) if ($teamcode and scalar @member == 0);

}

sub testR
{
   my %tt;
   while (<IN>)
   {
      chomp;  s/\s*$//;
      next if /^$/ || /^%/; # skip empty lines and comments
      $_ = russian($_, $in_charset, $innercode);
      my ($tour,$teamcode,@result) = split;
      error ($msg_badtour,$f,$tour) unless $tour && $tour<=$ntours;
      error ($msg_unknownteam,$f,$teamcode) if ! exists $team{$teamcode};
      error ($msg_doubletour,$f,$teamcode,$tour) if exists $tt{$teamcode}{$tour};
      $tt{$teamcode}{$tour}=1;
      my $sum = pop @result;
      my $res = join "",@result;
      for $q (@qbad) {
         if ( ($tour-1)*$nq < $q  &&  $q <= $tour*$nq  &&
              substr($res, $q-($tour-1)*$nq-1,1) eq '+')
         {
            error ($msg_deletedquestion,$f,$teamcode,$tour,$q);
         }
      }         
      my $nplus = $res =~ tr/+//;
      my $nminus = $res =~ tr/-//;
      error ($msg_badplusminus,$f,$teamcode,$tour) unless $nplus+$nminus == $nq;
      error ($msg_badsymbol,$f,$teamcode,$tour) unless $nplus+$nminus == length $res;
      error ($msg_badsum,$f,$teamcode,$tour) unless $nplus == $sum;
   }
   my ($teamcode,$tour);
   for $teamcode (sort keys %team)
   {
      for $tour (1..$ntours)
      {
         error ($msg_notour,$f,$teamcode,$tour)
            unless exists $tt{$teamcode}{$tour}
      }
   }
}
